/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package solution;

/** 
 * @author Matthew Gregory
 * website: www.matthewgregory-author.com.au
 *
 */
public class Person {

    public String firstName;
    public String lastName;
    public int age;
    
    //Constructor with two arguements
    public Person(String firstName, String lastName) {
        setNames(firstName,lastName);
    }
    
    public Person() {
    }

    public String getFullName(){
        return Utilities.capitalise(firstName+" "+lastName);
    }
    
    public void printDetails(){
        System.out.println("First Name: "+firstName);
        System.out.println("Last Name: "+lastName);
        System.out.println("Full Name: "+getFullName());
    }

    public void setNames(String firstName, String lastName){
        this.firstName = firstName.toUpperCase();
        this.lastName = lastName.toUpperCase();
    } 
    
    public String toString(){
        return getFullName();
    }
    
}
